/*
 * Copyright (C) 2011 OGIS-RI Co., Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.forwarding.transformer.impl;

import java.net.MalformedURLException;
import java.util.Map;

import jp.co.ogis_ri.citk.forwarding.transformer.EndpointUrl;
import jp.co.ogis_ri.citk.forwarding.transformer.OutboundEndpoint;
import jp.co.ogis_ri.citk.forwarding.transformer.OutboundEndpointResolver;


/**
 * アウトバウンドエンドポイント解決クラス実装。
 * @author ISP Shiraishi
 *
 */
public class MemoryOutboundEndpointResolverImpl implements OutboundEndpointResolver {

	/**
     * エンドポイントのMAPビルダークラス。
     */
	private EndpointUrlBuilder endpointUrlBuilder;

	/**
	 * @return endpointUrlBuilder
	 */
	public EndpointUrlBuilder getEndpointUrlBuilder() {
		return endpointUrlBuilder;
	}

	/**
	 * @param endpointUrlBuilder セットする endpointUrlBuilder
	 */
	public void setEndpointUrlBuilder(EndpointUrlBuilder endpointUrlBuilder) {
		this.endpointUrlBuilder = endpointUrlBuilder;
	}

	@Override
	/**
     * アウトバウンドエンドポイント解決メソッド。
     * @param targetKey ターゲットリソースを表すキー
     * @param authzResult　認可結果
     * @return エンドポイント情報
     */
	public OutboundEndpoint resolve(String targetKey, String authzResult){
		// URLの論理 -> 物理変換
		Map<String, EndpointUrl> endpointUrls = null;
		
		try {
			endpointUrls = endpointUrlBuilder.build();
		} catch (MalformedURLException e) {
			throw new RuntimeException(e);
		}
	
		if(!endpointUrls.containsKey(targetKey)){
			throw new RuntimeException();
		}
		EndpointUrl endpointUrl = endpointUrls.get(targetKey);
		
		return endpointUrl.getOutboundEndpoint(authzResult);
	}
}
