package jp.co.ogis_ri.citk.forwarding.transformer;

import static org.junit.Assert.*;
import jp.co.ogis_ri.citk.common.CitkConstants;
import jp.co.ogis_ri.citk.forwarding.transformer.EndpointUrl;
import jp.co.ogis_ri.citk.forwarding.transformer.OutboundEndpoint;

import org.junit.Test;


public class EndpointUrlTestCase {

	private static OutboundEndpoint permitEndpoint =
				new OutboundEndpoint("http","sp.citk201.com",8080,"/sp1/test.html","","GET");
	private static OutboundEndpoint denyEndpoint =
			new OutboundEndpoint("http","sp.citk202.com",8080,"/sp1/test.html","","GET");
	private static OutboundEndpoint indeterminateEndpoint =
			new OutboundEndpoint("http","sp.citk203.com",8080,"/sp1/test.html","","GET");
	

	@Test
	public void testGetOutboundEndpoint_permit() {
		EndpointUrl endpointUrl = new EndpointUrl();	
		endpointUrl.setPermit(permitEndpoint);	
		OutboundEndpoint permit = endpointUrl.getOutboundEndpoint(CitkConstants.AUTHZ_PERMIT);
		
		assertEquals(permitEndpoint, permit);
	}
	
	@Test
	public void testGetOutboundEndpoint_deny() {
		EndpointUrl endpointUrl = new EndpointUrl();
		endpointUrl.setDeny(denyEndpoint);
		OutboundEndpoint deny = endpointUrl.getOutboundEndpoint(CitkConstants.AUTHZ_DENY);

		assertEquals(denyEndpoint, deny);

	}
	
	@Test
	public void testGetOutboundEndpoint_indeterminate() {
		EndpointUrl endpointUrl = new EndpointUrl();
		endpointUrl.setIndeterminate(indeterminateEndpoint);
		OutboundEndpoint indeterminate = endpointUrl.getOutboundEndpoint(CitkConstants.AUTHZ_INDETERMINATE);
		
		assertEquals(indeterminateEndpoint, indeterminate);
	}
	
	
	@Test(expected = RuntimeException.class)
	public void testGetOutboundEndpoint_exception() {
		EndpointUrl endpointUrl = new EndpointUrl();
		OutboundEndpoint hoge = endpointUrl.getOutboundEndpoint("hoge");
	}

}
