package jp.co.ogis_ri.citk.forwarding.transformer;

import static org.junit.Assert.*;

import java.net.MalformedURLException;
import java.net.URL;

import jp.co.ogis_ri.citk.forwarding.transformer.OutboundEndpoint;

import org.junit.Test;

public class OutboundEndpointTestCase {

	public static String protocol = "http";
	public static String host = "sp.citk201.com";
	public static int port = 8080;
	public static String appcontext = "/sp1/test/index.html";
	public static String path = "";
	public static String method = "GET";
	public static String urlString = protocol + "://" + host + ":" + port + appcontext;
	
	@Test
	public void testOutboundEndpointURL() {
		URL url = null;
		try {
			url = new URL(urlString);
		} catch (MalformedURLException e) {
			fail("テスト用URLが不正です");
		}
		
		OutboundEndpoint target = new OutboundEndpoint(url);
		
		assertEquals(target.getClass(),OutboundEndpoint.class);
		
	}

	@Test
	public void testOutboundEndpointStringStringIntStringStringString() {
		OutboundEndpoint target = new OutboundEndpoint(protocol,host,port,appcontext,path,method);
		
		assertEquals(target.getClass(),OutboundEndpoint.class);
	}


	@Test
	public void testToString() {
		OutboundEndpoint target = new OutboundEndpoint(protocol,host,port,appcontext,path,method);
		assertEquals(urlString, target.toString());
	}

}
