package jp.co.ogis_ri.citk.forwarding.transformer.impl;

import static org.junit.Assert.*;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;

import jp.co.ogis_ri.citk.forwarding.transformer.EndpointUrl;
import jp.co.ogis_ri.citk.forwarding.transformer.impl.EndpointUrlBuilder;

import org.junit.Test;

public class EndpointUrlBuilderTestCase {

	private static String key = "sp1/app";
	private static String permitUrl = "http://sp1.citk.com:8080/test/";
	private static String denyUrl = "http://sp1.citk.com:8080/test/error.html";
	private static String indeterminateUrl = "http://sp1.citk.com:8080/test/error.html";
		
	@Test
	public void testBuild() throws Exception{
		EndpointUrlBuilder target = new EndpointUrlBuilder();
		
		Map<String, String > settingDatas;
		settingDatas = new HashMap<String,String>();
		settingDatas.put(key, permitUrl + "," + denyUrl + "," + indeterminateUrl);

		target.setSettingDatas(settingDatas);
		
		Map<String, EndpointUrl> result = target.build();
		
		EndpointUrl endpointUrl = result.get(key);
		assertEquals(permitUrl,  endpointUrl.getPermit().toString());
		assertEquals(denyUrl,  endpointUrl.getDeny().toString());
		assertEquals(indeterminateUrl,  endpointUrl.getIndeterminate().toString());
	}
	
	@Test(expected=MalformedURLException.class)
	public void testBuild_exception() throws Exception{
		EndpointUrlBuilder target = new EndpointUrlBuilder();

		Map<String, String > settingDatas;
		settingDatas = new HashMap<String,String>();
		settingDatas.put(key, "notURLformat,notURLformat,notURLformat");
		
		target.setSettingDatas(settingDatas);
		
		//Exception発生
		Map<String, EndpointUrl> result = target.build();

		fail("期待するExceptionが発生しませんでした。");
	}

}
