package jp.co.ogis_ri.citk.forwarding.transformer.impl;

import static org.junit.Assert.*;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;

import jp.co.ogis_ri.citk.common.CitkConstants;
import jp.co.ogis_ri.citk.forwarding.transformer.OutboundEndpoint;
import jp.co.ogis_ri.citk.forwarding.transformer.impl.EndpointUrlBuilder;
import jp.co.ogis_ri.citk.forwarding.transformer.impl.MemoryOutboundEndpointResolverImpl;

import org.junit.Test;

public class MemoryOutboundEndpointResolverImplTestCase {

	private static EndpointUrlBuilder endpointUrlBuilder;
	private static Map<String, String > settingDatas;
	private static String key = "sp1/app";
	private static String permitUrl = "http://sp1.citk.com:8080/test/";
	private static String denyUrl = "http://sp1.citk.com:8080/test/error.html";
	private static String indeterminateUrl = "http://sp1.citk.com:8080/test/error.html";
	
	static {
		settingDatas = new HashMap<String,String>();
		settingDatas.put(key, permitUrl + "," + denyUrl + "," + indeterminateUrl);
		endpointUrlBuilder = new EndpointUrlBuilder();
		endpointUrlBuilder.setSettingDatas(settingDatas);
	}

	@Test
	public void testResolve_permit() throws Exception{
		MemoryOutboundEndpointResolverImpl target = new MemoryOutboundEndpointResolverImpl();
		target.setEndpointUrlBuilder(endpointUrlBuilder);
		
		OutboundEndpoint permit = target.resolve(key, CitkConstants.AUTHZ_PERMIT);
		
		assertEquals(permitUrl, permit.toString());
	}
	
	@Test
	public void testResolve_deny() throws Exception{
		MemoryOutboundEndpointResolverImpl target = new MemoryOutboundEndpointResolverImpl();
		target.setEndpointUrlBuilder(endpointUrlBuilder);
		
		OutboundEndpoint deny = target.resolve(key, CitkConstants.AUTHZ_DENY);

		assertEquals(denyUrl, deny.toString());
	}
	
	@Test
	public void testResolve_indeterminate() throws Exception{
		MemoryOutboundEndpointResolverImpl target = new MemoryOutboundEndpointResolverImpl();
		target.setEndpointUrlBuilder(endpointUrlBuilder);
		
		OutboundEndpoint indeterminate = target.resolve(key, CitkConstants.AUTHZ_INDETERMINATE);
		
		assertEquals(indeterminateUrl, indeterminate.toString());
	}
	
	@Test(expected=RuntimeException.class)
	public void testResolve_MalformedURLException() throws Exception{
		MemoryOutboundEndpointResolverImpl target = new MemoryOutboundEndpointResolverImpl();
		
		Map<String, String > invalidSettingDatas = new HashMap<String,String>();
		invalidSettingDatas.put(key, "notURLFormat,notURLFormat,notURLFormat");
		EndpointUrlBuilder invalidUrlBuilder = new EndpointUrlBuilder();
		invalidUrlBuilder.setSettingDatas(invalidSettingDatas);
		
		target.setEndpointUrlBuilder(invalidUrlBuilder);
		
		//Exception発生
		OutboundEndpoint exception = target.resolve(key, CitkConstants.AUTHZ_PERMIT);
		
		fail("期待するExceptionが発生しませんでした。");
	}
	
	@Test(expected=RuntimeException.class)
	public void testResolve_InvalidKeyException() throws Exception{
		MemoryOutboundEndpointResolverImpl target = new MemoryOutboundEndpointResolverImpl();
		target.setEndpointUrlBuilder(endpointUrlBuilder);
		
		OutboundEndpoint permit = target.resolve(key, CitkConstants.AUTHZ_PERMIT);
		
		//Exception発生
		OutboundEndpoint exception = target.resolve("hoge", CitkConstants.AUTHZ_PERMIT);
		
		fail("期待するExceptionが発生しませんでした。");
	}

}
