/*
 * Copyright (C) 2011 OGIS-RI Co., Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.app;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.transport.PropertyScope;
import org.mule.module.client.MuleClient;
import org.mule.tck.FunctionalTestCase;
import org.mule.transport.NullPayload;
import org.mule.transport.http.CookieHelper;

public class AccessCheckFunctionalTestCase extends FunctionalTestCase {

    public AccessCheckFunctionalTestCase() {
        super();
        setFailOnTimeout(false);
    }

    @Override
    protected String getConfigResources() {
        return "src/test/resources/access.xml";
    }

    public void testValidCookie() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage request = new DefaultMuleMessage("valid", muleContext);

        Map<String, Object> map = new HashMap<String, Object>();
        Cookie[] obj = CookieHelper.parseCookiesAsAClient("iPlanetDirectoryPro=\"AQIC5wM2LY4Sfcw08P6sN5JDTMRPGeeG+b/E2GBBGKbSe4M=@AAJTSQACMDE=#\"",
            CookiePolicy.RFC_2109, new URI("http://my.citk.org:8008"));
        map.put("cookies", obj);
        request.addProperties(map, PropertyScope.OUTBOUND);

        MuleMessage reply = client.send("http://my.citk.org:8008", request);

        assertNotNull(reply.getInboundProperty("http.status"));
        assertEquals(reply.getInboundProperty("http.status"), "200");
        assertNotNull(reply.getPayload());
        assertFalse(reply.getPayload() instanceof NullPayload);
        assertNull(reply.getExceptionPayload());
        assertNull(reply.getInboundProperty("Content-Length"));
        assertEquals(reply.getInboundProperty("http.request"),"http://my.citk.org:8008/");
    }

    public void testBlankCookie() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage request = new DefaultMuleMessage("blank", muleContext);

        Map<String, Object> map = new HashMap<String, Object>();
        Cookie[] obj = 
            CookieHelper.parseCookiesAsAClient("iPlanetDirectoryPro=",
                    CookiePolicy.RFC_2109, 
                    new URI("http://my.citk.org:8008"));
        map.put("cookies", obj);
        request.addProperties(map, PropertyScope.OUTBOUND);

        MuleMessage reply = client.send("http://my.citk.org:8008", request);

        assertNotNull(reply.getInboundProperty("http.status"));
        assertEquals(reply.getInboundProperty("http.status"), "302");
        assertNull(reply.getExceptionPayload());
        assertNotNull(reply.getInboundProperty("Location"));
        assertTrue(((String)reply.getInboundProperty("Location")).startsWith("http://my.citk.org:8888/opensso/SSORedirect/metaAlias/test?"));
    }

    public void testNoCookie() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage request = new DefaultMuleMessage("nothing", muleContext);

        Map<String, Object> map = new HashMap<String, Object>();
        Cookie[] obj = 
            CookieHelper.parseCookiesAsAClient("invalidcookiename=",
                    CookiePolicy.RFC_2109, 
                    new URI("http://my.citk.org:8008"));
        map.put("cookies", obj);
        request.addProperties(map, PropertyScope.OUTBOUND);

        MuleMessage reply = client.send("http://my.citk.org:8008", request);

        assertNotNull(reply.getOutboundProperty("http.status"));
        assertEquals(reply.getOutboundProperty("http.status"), "302");
        assertNull(reply.getExceptionPayload());
        assertNotNull(reply.getInboundProperty("Location"));
        assertTrue(((String)reply.getInboundProperty("Location")).startsWith("http://my.citk.org:8888/opensso/SSORedirect/metaAlias/test?"));

    }
}
