/*
 * Copyright (C) 2011 OGIS-RI Co., Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.app;


import org.mule.DefaultMuleMessage;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.FunctionalTestCase;
import org.mule.transport.NullPayload;

public class AssersionCheckFunctionalTestCase extends FunctionalTestCase {

    public AssersionCheckFunctionalTestCase() {
        super();
        setFailOnTimeout(false);
    }

    @Override
    protected String getConfigResources() {
        return "src/test/resources/assersion.xml";
    }

    public void testInvalidSAMLResponse() throws Exception {
        String message = "SAMLResponse=dummy";
        String encode = "iso-8859-1";

        MuleClient client = new MuleClient(muleContext);
        MuleMessage request = new DefaultMuleMessage(message, muleContext);

        request.setEncoding(encode);
        request.setOutboundProperty("http.method", "POST");
        request.setOutboundProperty("Content-Type", "application/x-www-form-urlencoded");
        request.setOutboundProperty("Content-Length", message.getBytes(encode).length);

        MuleMessage reply = client.send("http://my.citk.org:8008/acs", request);


        // SAMLResponseの値が正しくないためfedletが500を返す
        assertNotNull(reply.getInboundProperty("http.status"));
        assertEquals(reply.getInboundProperty("http.status"), "500");
        assertNotNull(reply.getPayload());
        ExceptionPayload e = reply.getExceptionPayload();
        assertNotNull(e);
        assertNotNull(e.getCode());
        assertNotNull(e.getMessage());
        assertNotNull(e.getException());
        assertNotNull(e.getRootException());
        assertTrue(e.getRootException() instanceof org.mule.transport.http.HttpResponseException);
    }

    public void testInvalidSAMLArt() throws Exception {
        String message = "SAMLArt=dummy";
        String encode = "iso-8859-1";

        MuleClient client = new MuleClient(muleContext);
        MuleMessage request = new DefaultMuleMessage(message, muleContext);

        request.setEncoding(encode);
        request.setOutboundProperty("http.method", "POST");
        request.setOutboundProperty("Content-Type", "application/x-www-form-urlencoded");
        request.setOutboundProperty("Content-Length", message.getBytes(encode).length);

        MuleMessage reply = client.send("http://my.citk.org:8008/acs", request);


        // 未実装のため200が返る
        assertFalse(reply.getPayload() instanceof NullPayload);
        assertNull(reply.getExceptionPayload());
    }

    public void testNotSAMLMessage() throws Exception {
        String message = "foo=bar";
        String encode = "iso-8859-1";

        MuleClient client = new MuleClient(muleContext);
        MuleMessage request = new DefaultMuleMessage(message, muleContext);

        request.setEncoding(encode);
        request.setOutboundProperty("http.method", "POST");
        request.setOutboundProperty("Content-Type", "application/x-www-form-urlencoded");
        request.setOutboundProperty("Content-Length", message.getBytes(encode).length);

        MuleMessage reply = client.send("http://my.citk.org:8008/acs", request);

        // 未実装のため200が返る
        assertFalse(reply.getPayload() instanceof NullPayload);
        assertNull(reply.getExceptionPayload());
    }

    public void testNoMessage() throws Exception {
        String message = "";
        String encode = "iso-8859-1";

        MuleClient client = new MuleClient(muleContext);
        MuleMessage request = new DefaultMuleMessage(message, muleContext);

        request.setEncoding(encode);
        request.setOutboundProperty("http.method", "POST");
        request.setOutboundProperty("Content-Type", "application/x-www-form-urlencoded");
        request.setOutboundProperty("Content-Length", message.getBytes(encode).length);

        MuleMessage reply = client.send("http://my.citk.org:8008/acs", request);
        // 未実装のため200が返る
        assertFalse(reply.getPayload() instanceof NullPayload);
        assertNull(reply.getExceptionPayload());
    }
}
