/*
 * Copyright (C) 2011 OGIS-RI Co., Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.app;

import java.util.Map;

import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.FunctionalTestCase;

/**
 * 認可モジュールをMuleに組み込んだときの機能テスト
 * 
 * @author Saito_Shinya@ogis-ri.co.jp
 *
 */
public class AuthzFunctionalTestCase extends FunctionalTestCase {
	
	@Override
	protected String getConfigResources() {
		return "test-mule-config.xml";
	}
	
	@Test
	public void testSendHTTPMessage() throws Exception {
		MuleClient client = new MuleClient(true);
		String endpoint = "http://localhost:65080/localhost";
		
		MuleMessage result = client.send(endpoint, "amadmin",(Map)null);
		String resultString = result.getPayloadAsString();
		assertEquals("Deny", resultString);
		
	}	
}
