/*
 * Copyright (C) 2011 OGIS-RI Co., Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.app;

import java.io.FileNotFoundException;

import jp.co.ogis_ri.citk.authz.xacml.XACMLQuery;

import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleEventContext;
import org.mule.api.transport.PropertyScope;
import org.mule.config.dsl.ComponentBuilder.Scope;
import org.mule.tck.functional.FunctionalTestComponent;



public class AuthzFunctionalTestComponent extends FunctionalTestComponent {

	private static final String PDP_ENTITY = "citkidp";
	private static final String PEP_ENTITY = "citksp";
	
	private XACMLQuery target;
	
	@Override
	public void initialise(){
		target = new XACMLQuery();
		target.setPdpEntity(PDP_ENTITY);
		target.setPepEntity(PEP_ENTITY);
		
		super.initialise();
	}
	
	@Override
	public Object onCall(MuleEventContext context) throws Exception {
		
		String subjectId = context.getMessageAsString();
		String resourceServiceName = "iPlanetAMWebAgentService";
		String resourceId = context.getMessage().getProperty("http.request.path",PropertyScope.INBOUND);
		String actionId = context.getMessage().getProperty("http.method",PropertyScope.INBOUND);
		resourceId = "http://" + StringUtils.strip(resourceId,"/") + ":8080/";
		
		return target.getPolicyDecisionByUserID(subjectId, resourceServiceName, resourceId, actionId);
	}
	
}
