/*
 * Copyright (C) 2011 OGIS-RI Co., Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.app;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.transport.PropertyScope;
import org.mule.module.client.MuleClient;
import org.mule.tck.FunctionalTestCase;
import org.mule.transport.NullPayload;
import org.mule.transport.http.CookieHelper;

public class AuthzHandlerFunctionalTestCase extends FunctionalTestCase {

    public AuthzHandlerFunctionalTestCase() {
        super();
        setFailOnTimeout(false);
        
    }
    
    
    @Override
    protected String getConfigResources() {
    	return "src/main/app/mule-config.xml";
    }

    public void testValidCookie() throws Exception {

    	//ToDo: キャッシュに事前に認証方法を収めるすべがない
    	
        MuleClient client = new MuleClient(muleContext);
        MuleMessage request = new DefaultMuleMessage("valid", muleContext);

        

        MuleMessage reply = client.send("vm://authzHandler", request);

        assertNotNull(reply.getInboundProperty("http.status"));
        assertEquals(reply.getInboundProperty("http.status"), "302");
        assertNotNull(reply.getPayload());
        assertFalse(reply.getPayload() instanceof NullPayload);
        assertNull(reply.getExceptionPayload());
        assertNull(reply.getInboundProperty("Content-Length"));
        assertEquals(reply.getInboundProperty("http.request"),"http://sp.citk.com:8008/");
    }

}
