/**
 * Copyright (C) 2011 OGIS-RI Co., Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.citk.it.sp.stub.app.controller;

import java.io.IOException;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class StubController {

	@RequestMapping(value = "/index",  method = RequestMethod.GET)
	public String index(Model model) {
		return "index";
	}
	
	 //getメソッド
	@RequestMapping(value = "/getmethod",  method = RequestMethod.GET)
	public String initPath1(Model model) {
		model.addAttribute("output", generateOutput("getMethodTest"));
		return "getmethod";
	}
	
	//postメソッド
	@RequestMapping(value = "/postmethod", method = RequestMethod.GET)
	public String registerInput(Model model) {
		if (!model.containsAttribute("msg")) {
            model.addAttribute(new Message());
    	}
		return "postmethod";
	}
	
	@RequestMapping(value = "/postmethod", method = RequestMethod.POST)
	public String register() {
        return "redirect:/webbapp/app/postmsg";
    }
	
	@RequestMapping(value = "/postmsg", method = RequestMethod.POST)
	public String postMsg() {
        return "postmsg";
    }
	
	//リダイレクト(絶対パス)
	@RequestMapping(value = "/redirectab", method = RequestMethod.GET)
	public String redirectToAbsolutePass(Model model){
		return "redirect:http://www.yahoo.co.jp/";
	}
	
	//リダイレクト(相対パス)
	@RequestMapping(value = "/redirect", method = RequestMethod.GET)
	public String redirectToRelativePass(){
		return "redirect:/app/redirected";
	}
	
	@RequestMapping(value = "/redirected", method = RequestMethod.GET)
	public String redirectToPass(Model model){
		model.addAttribute("output", generateOutput("relative pass"));
		return "redirected";
	}
	
	//セッションIDが保持できる事を確認する
	@RequestMapping(value = "/session", method = RequestMethod.GET)
	public String sessionDo(HttpServletRequest request, HttpServletResponse response, Model model)
			throws IOException {
		//セッションの取得
		HttpSession sess = request.getSession(true);
		
		//セッションからオブジェクトの取得
		Integer count_s = (Integer) sess.getAttribute("count");
		String sessionId = sess.getId();
		
		//カウンタを +1
		if(count_s == null){
			count_s = new Integer(0);
		}
		count_s = new Integer(count_s.intValue() + 1);
		
		//セッションにオブジェクトの格納
		sess.setAttribute("count", count_s);
		model.addAttribute("output_count", count_s);
		model.addAttribute("output_sessionid",sessionId);
		
		return "session";
		      
	}
	@RequestMapping(value = "/session", method = RequestMethod.POST)
	public String sessionRem(HttpServletRequest request, HttpServletResponse response, Model model) {
		HttpSession sess = request.getSession();
		sess.invalidate();
        return "session";
    }
	
	//クッキーが保持できる事を確認する
		@RequestMapping(value = "/cookie", method = RequestMethod.GET)
		public String cookieDo(HttpServletRequest request, HttpServletResponse response, Model model)
				throws IOException {
			//クッキーの配列を取得
			Cookie[] cookies = request.getCookies();
			
			Integer count = null;
			
			//取得したクッキーの配列にcountという名前がないか確認
			if(cookies != null){
				for (int i = 0; i < cookies.length; i++){
					Cookie cookie = cookies[i];
					if(cookie.getName().equals("count")){
						String value = cookie.getValue();
						count = Integer.valueOf(value);
						break;
					}
				}
			}
			
			if(count == null){
				count = new Integer(0);
			}
			
			count = new Integer(count.intValue() + 1);
			
			//クッキーオブジェクトを作成し、5日間保存
			Cookie cookie = new Cookie("count", count.toString());
			cookie.setMaxAge(60 * 60 * 24 * 5);
			response.addCookie(cookie);
			
			model.addAttribute("output_username", "citk");
			model.addAttribute("output_cookie",cookie);
			model.addAttribute("output_count", count);
			return "cookie";
		}
	
	//500エラーを発生させる
	@RequestMapping(value = "exception", method = RequestMethod.GET)
	public String exceptionDo(HttpServletRequest request,
			HttpServletResponse response,Model model) throws Exception{
		throw new RuntimeException();
	}
	
	private String generateOutput(String s) {
		return "This page is redirected by " + s + ".";		
	}
	
}
