package manager;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropsManager {

	private static final String PATH = "/testclient.properties";

	private static Properties props = new Properties();

	static {
		InputStream in = null;
		try {
			in = PropsManager.class.getResourceAsStream(PATH);
			props.load(in);

		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			closeResource(in);
		}
	}

	public static String getValue(String key) {
		return props.getProperty(key);
	}

	private static void closeResource(Closeable resource) {
		try {
			if (resource != null) {
				resource.close();
			}
		} catch (IOException e) {
			// no operation
		}
	}
}
