/**
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2009 Sun Microsystems Inc. All Rights Reserved
 *
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at
 * https://opensso.dev.java.net/public/CDDLv1.0.html or
 * opensso/legal/CDDLv1.0.txt
 * See the License for the specific language governing
 * permission and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at opensso/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * $Id: LogClientHandler.java,v 1.1 2009/07/25 01:11:03 Kamna Exp $
 *
 */
package stub.sp.it.citk.org.log;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

public class SOAPMessageLogger implements SOAPHandler<SOAPMessageContext> {

	private static final String LOG_DIR = System.getProperty("user.home");

	public boolean handleMessage(SOAPMessageContext context) {

		Boolean outboundProperty = (Boolean) context
				.get(MessageContext.MESSAGE_OUTBOUND_PROPERTY);

		if (!outboundProperty.booleanValue()) {
			// logging Response Data
			logResponse(context);

		} else {
			// logging Request Data
			logRequest(context);
		}

		return true;
	}

	public Set<QName> getHeaders() {
		Set<QName> qnames = new HashSet<QName>();
		qnames.add(new QName("http://docs.oasis-open.org/wss/2004/01/"
				+ "oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security",
				"wsse"));
		return (qnames);
	}

	public boolean handleFault(SOAPMessageContext mc) {
		return true;
	}

	public void close(MessageContext context) {
	}

	private void logResponse(SOAPMessageContext context) {

		String fileName = LOG_DIR + "/openam_951/response";
		try {
			PrintStream out = new PrintStream(new FileOutputStream(fileName,
					false));
			context.getMessage().writeTo(out);
			out.close();
		} catch (SOAPException ex) {
			ex.printStackTrace();
		} catch (IOException ex) {
			ex.printStackTrace();
		}
	}

	private void logRequest(SOAPMessageContext context) {

		String fileName = LOG_DIR + "/openam_951/request";
		try {
			PrintStream out = new PrintStream(new FileOutputStream(fileName,
					false));
			context.getMessage().writeTo(out);
			out.close();
		} catch (SOAPException ex) {
			ex.printStackTrace();
		} catch (IOException ex) {
			ex.printStackTrace();
		}
	}
}
