/**
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2009 Sun Microsystems Inc. All Rights Reserved
 *
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at
 * https://opensso.dev.java.net/public/CDDLv1.0.html or
 * META-INF/CDDLv1.0.txt
 * See the License for the specific language governing
 * permission and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at META-INF/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * $Id: ClientHandler.java,v 1.5 2009/11/04 04:55:42 kamna Exp $
 *
 */

package jp.co.ogis_ri.citk.wssagents.jaxws.client;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

import com.sun.identity.wss.security.handler.SOAPRequestHandler;
import com.sun.identity.wss.security.handler.SOAPRequestHandlerInterface;
import com.sun.identity.wss.security.handler.ThreadLocalService;

/**
 * WS-Security 
 * 
 */
public class ClientHandler implements SOAPHandler<SOAPMessageContext>{

    private static final Logger logger =
        Logger.getLogger("com.sun.identity.wssagents.jaxws.security");
	
    private String wscProfile;
    
    /**
     * Gets the header blocks that can be processed by this Handler instance.
     * 
     * @return 
     */
	public Set<QName> getHeaders() {
		Set<QName> qnames = new HashSet<QName>();
		qnames.add(new QName ( 
	        "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd",
			"Security","wsse"));
		return qnames;
	}
	
	/**
	 * 
	 * @param context
	 */
	public boolean handleFault(SOAPMessageContext context) {
        if(logger != null && logger.isLoggable(Level.SEVERE)) {
            logger.log(Level.SEVERE,
                "ClientHandler.handleFault : " +
                context.getMessage().getSOAPPart().toString());
        }
	    return true;
	}
	
	/**
	 * 
	 * @param context
	 */
	public boolean handleMessage(SOAPMessageContext context) {

		Boolean outboundMsg =
            (Boolean)context.get(MessageContext.MESSAGE_OUTBOUND_PROPERTY);

        SOAPRequestHandlerInterface handler = null;
        try {
		    handler = new SOAPRequestHandler();
		    Map<String, Object> map = new HashMap<String, Object>();

            // Set the WSC provider name for WSC profile
		    map.put("providername", wscProfile);
		    handler.init(map);
		} catch (Exception ex) {
		    if(logger != null && logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE,
                    "ClientHandler.initialization failed : ", ex);
            }
            return false;
		}
        
        // secureRequest/validateResponse parameter
        @SuppressWarnings("all")
        Map param = new HashMap();

	    //Outbound Message from Client = REQUEST
	    if(outboundMsg.booleanValue()){
            if(logger != null && logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "ClientHandler: Outgoing Request : " +
                    handler.print(context.getMessage().getSOAPPart()));
            }

            try {
                Subject subject = null;
                subject = (Subject)ThreadLocalService.getSubject();
                if(subject == null) {
	                if(logger != null && logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "ClientHandler.subject NULL");
                    }
	                subject = new Subject();
	            } else {
                    ThreadLocalService.removeSubject();
                }
                handler.secureRequest(context.getMessage(), subject, param);
                return true;
		    } catch (Exception ex) {
		        if(logger != null && logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE,
                        "ClientHandler.secureRequest failed : ", ex);
                }
                throw new ProtocolException(ex.toString());
		    }
	    } else {
            //if outbound RESPONSE
			if(logger != null && logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "ClientHandler: Incoming Response : " +
                    handler.print(context.getMessage().getSOAPPart()));
            }

            try {
		        handler.validateResponse(context.getMessage(), param);
                return true;
		    } catch (Exception ex) {
		        if(logger != null && logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE,
                        "ClientHandler.validateResponse failed : ", ex);
                }
                throw new ProtocolException(ex.toString());
		    }
	    }
	}

	/**
	 * @param context
	 */
	public void close(MessageContext context) {
		//No operation
	}    
	
	public void setWscProfile(String wscProfile){
	    this.wscProfile = wscProfile;
	}
}
