/**
 * Copyright (C) 2011 OGIS-RI Co., Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.wsp.interceptor;

import static jp.co.ogis_ri.citk.authz.common.AuthzConstants.DEFAULT_SERVICE_NAME;

import java.security.Principal;

import javax.security.auth.Subject;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import jp.co.ogis_ri.citk.authz.xacml.XACMLQuery;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.interceptor.Interceptor;
import org.mule.api.processor.MessageProcessor;

import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.wss.security.handler.ThreadLocalService;

/**
 * The interceptor contributed to inbound request message or outbound response
 * message interceptor.
 * 
 */
public class AuthorizationInterceptor implements Interceptor {

	private static Log log = LogFactory.getLog(AuthorizationInterceptor.class);

	private XACMLQuery xacmlQuery = new XACMLQuery();

	@Override
	public void setListener(MessageProcessor arg0) {
	}

	@Override
	public MuleEvent process(MuleEvent event) throws MuleException {

		if (log.isInfoEnabled()) {
			log.info(AuthorizationInterceptor.class + "process()");
		}

		// アクセス先リソース
		String resource = event.getMessageSourceURI().toString();

		// ユーザID
		String userId = getUserId();

		try {
			// 認可
			String ret = xacmlQuery.getPolicyDecisionByUserID(userId,
					DEFAULT_SERVICE_NAME, resource, "GET");

			// [TODO] 認可結果をどう扱おうかのぅ。
			System.out.println("認可結果 = " + ret);

		} catch (SAML2Exception e) {
			// [TODO] ホントはCITKRuntimeException的なものを投げて欲しい。。。
			e.printStackTrace();
		}
		return event;
	}

	private String getUserId() {

		String userId = "";

		Subject subject = (Subject) ThreadLocalService.getSubject();
		for (Principal principal : subject.getPrincipals()) {
			String[] tmp = principal.getName().split(",");

			String ou = getValueByKey(tmp, "ou");
			if ("user".equals(ou)) {
				userId = getValueByKey(tmp, "id");
				break;
			}
		}
		return userId;
	}

	private String getValueByKey(String[] array, String key) {
		String value = null;
		for (String data : array) {
			if (data.startsWith(key))
				value = data.split("=")[1];
		}
		return value;
	}

	public void setPdpEntity(String pdpEntity) {
		xacmlQuery.setPdpEntity(pdpEntity);
	}

	public void setPepEntity(String pepEntity) {
		xacmlQuery.setPepEntity(pepEntity);
	}
}
