/**
 * Copyright (C) 2011 OGIS-RI Co., Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.wsp.cxf.jaxws.handler;

import java.util.Map;

import javax.security.auth.Subject;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.binding.soap.SoapMessage;

/**
 * JAX-WS Handler(SOAPHandler) inbound component.
 * 
 */
public class WsHandler extends AbstractWsHandler {

	private static Log log = LogFactory.getLog(WsHandler.class);

	@Override
	protected void handleSecureMessage(SoapMessage message,
			SOAPMessageContext context, ThreadLocal<Subject> cred,
			Subject subject, Map<Object,Object> sharedMap) {

		// outboundMsg : [true: Outgoing RESPONSE, false :Incoming REQUEST]
		Boolean outboundMsg = (Boolean) context
				.get(MessageContext.MESSAGE_OUTBOUND_PROPERTY);

		if (!(outboundMsg.booleanValue())) {
			// incoming Request process
			handleIncomingRequest(message, context, cred, subject, sharedMap);

		} else {
			// outgoing Response process
			handleOutgoingResponse(message, context, cred, subject, sharedMap);
		}
	}

	private void handleIncomingRequest(SoapMessage message,
			SOAPMessageContext context, ThreadLocal<Subject> cred,
			Subject subject, Map<Object,Object> sharedMap) {

		if (log.isDebugEnabled()) {
			log.debug(WsHandler.class + ": Incoming Request : "
					+ requestHandler.print(context.getMessage().getSOAPPart()));
		}

		try {
			// validate REQUEST from Client
			requestHandler.validateRequest(context.getMessage(), subject,
					sharedMap, null, null);
			synchronized (this) {
				cred.set(subject);
			}

			// set XMLReader for SOAP
			message.setContent(XMLStreamReader.class, getSOAPReader(context));

		} catch (Exception ex) {
			if (log.isDebugEnabled()) {
				log.debug(WsHandler.class + ".validateRequest failed : ", ex);
			}
			throw new ProtocolException(ex);
		}
	}

	private void handleOutgoingResponse(SoapMessage message,
			SOAPMessageContext context, ThreadLocal<Subject> cred,
			Subject subject, Map<Object,Object> sharedMap) {

		if (log.isDebugEnabled()) {
			log.debug(WsHandler.class + ": Outgoing Response : "
					+ requestHandler.print(context.getMessage().getSOAPPart()));
		}

		try {
			// secure RESPONSE to Client
			requestHandler.secureResponse(context.getMessage(), sharedMap);

		} catch (Exception ex) {
			if (log.isDebugEnabled()) {
				log.debug(WsHandler.class + ".secureResponse failed : ", ex);
			}
			throw new ProtocolException(ex);
		}
	}
}
