package jp.co.ogis_ri.citk.policytool.common.api;

import java.util.List;

import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Realm;

/**
 * OpenAM にアクセスするためのAPI.
 */
public interface OpenAMAccess {

    /**
     * 指定されたレルム名, フィルターを用いて, 該当するレルムを取得する.
     *
     * @param realmName レルム名.
     * @param filter フィルター.
     * @return Realmのリスト.
     *
     */
    List<Realm> getRealms(String realmName, String filter);
    
    /**
    * ポリシーを取得する.
    * なお、ドメインモデルのポリシーには、レルム名を含める必要があるため、原則として
    * レルム単位でポリシーを取得する必要がある。よって、レルム名は必須となる。
    * 
    * @param realmName レルム名.
    * @param policyName ポリシー名.
    * @return Policyのリスト.
    */
   List<Policy> getPolicies(String realmName, String policyName);
   
    /**
     * ポリシーに作成する.
     *
     * @param policy ポリシー
     */
    void createPolicy(Policy policy);
    
    /**
     * ポリシーに更新する.
     *
     * @param policy ポリシー
     */
    void updatePolicy(Policy policy);

    /**
     * ポリシーを削除する.
     *
     * @param policy ポリシー
     */
    void deletePolicy(Policy policy);    
}
