package jp.co.ogis_ri.citk.policytool.common.api.impl.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "attribute",
    "value"
})
@XmlRootElement(name = "AttributeValuePair")
public class OpenAMAttributeValuePair {

    @XmlElement(name = "Attribute", required = true)
    protected OpenAMAttribute attribute;
    @XmlElement(name = "Value", required = true)
    protected List<String> value;

    /**
     * Gets the value of the attribute property.
     * 
     * @return
     *     possible object is
     *     {@link OpenAMAttribute }
     *     
     */
    public OpenAMAttribute getAttribute() {
        return attribute;
    }

    /**
     * Sets the value of the attribute property.
     * 
     * @param value
     *     allowed object is
     *     {@link OpenAMAttribute }
     *     
     */
    public void setAttribute(OpenAMAttribute value) {
        this.attribute = value;
    }

    /**
     * Gets the value of the value property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the value property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getValue().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     */
    public List<String> getValue() {
        if (value == null) {
            value = new ArrayList<String>();
        }
        return this.value;
    }

}
