package jp.co.ogis_ri.citk.policytool.common.api.impl.ssoadm;
import java.util.ArrayList;
import java.util.List;


import org.apache.commons.lang3.StringEscapeUtils;

/**
 * 非公開クラス
 */
class GroupSsoadmResultParser extends AbstractSsoadmResultParser {
	/**
	 * データ部分の接頭辞.
	 */
	private final String DATA_PREFIX = "&#xa;";
	
	/**
	 * データ部分の接尾辞.
	 */
	private final String DATA_SUFFIX = "&#xa;";
	
	/**
	 * データ部分を分割する文字列.
	 */
	private final String DATA_SPLIT = "&#xa;";

	@Override
	protected List<String> parseData(String s) {
		List<String> data  = new ArrayList<String>();
		String groups = cutText(DATA_PREFIX, DATA_SUFFIX, s, false);
		for(String group : groups.split(DATA_SPLIT)) {
            group = StringEscapeUtils.unescapeXml(group);
			if(group.indexOf("(") != -1) {
				data.add(group);
			}
		}
		return data;
	}
}
