package jp.co.ogis_ri.citk.policytool.common.api.impl.ssoadm;
import java.util.ArrayList;
import java.util.List;


import org.apache.commons.lang3.StringEscapeUtils;

/**
 * 非公開クラス
 */
class PoliciesSsoadmResultParser extends AbstractSsoadmResultParser {
	/**
	 * データ部分の接頭辞.
	 */
	private final String DATA_PREFIX = "&lt;&#x3f;xml";
	
	/**
	 * データ部分の接尾辞.
	 */
	private final String DATA_SUFFIX = "Policies&gt;";
	
	/**
	 * ポリシーがないときの&lt;Policies&gt;要素の文字列.
	 */
    private final String EMPTY = "<Policies/>";

	@Override
	protected List<String> parseData(String s) {
		List<String> data  = new ArrayList<String>();
		String xml = cutText(DATA_PREFIX, DATA_SUFFIX, s, true);
		if(xml.length() != 0) {
		    data.add(StringEscapeUtils.unescapeXml(xml));
		}
		else {
            data.add(EMPTY);
		}
		return data;
	}
}
