package jp.co.ogis_ri.citk.policytool.common.api.impl.ssoadm;
import java.util.ArrayList;
import java.util.List;


import org.apache.commons.lang3.StringEscapeUtils;

/**
 * 非公開クラス
 */
class RealmSsoadmResultParser extends AbstractSsoadmResultParser {
	/**
	 * データ部分の接頭辞.
	 */
	private final String DATA_PREFIX = "&#xa;";
	
	/**
	 * データ部分の接尾辞.
	 */
	private final String DATA_SUFFIX = "&#xa;";
	
	/**
	 * データを分割する文字列.
	 */
	private final String DATA_SPLIT = "&#xa;";
	
	/**
	 * 検索が終了したときに出力されるメッセージ文字列.
	 */
	private final String MESSAGE = "検索が終了しました。";
	
	/**
	 * レルムがなかったときに出力されるメッセージ文字列.
	 */
	private final String REALM_ZERO_MESSAGE = "レルムがありませんでした。";

	@Override
	protected List<String> parseData(String s) {
		List<String> data  = new ArrayList<String>();
        String realms = cutText(DATA_PREFIX, DATA_SUFFIX, s, false);
		for(String realm : realms.split(DATA_SPLIT)) {
			realm = StringEscapeUtils.unescapeXml(realm);
			if(realm.length() != 0 && !MESSAGE.equals(realm)
					&& !REALM_ZERO_MESSAGE.equals(realm)) {
				data.add(realm.trim());
			}
		}
		return data;
	}
}
