package jp.co.ogis_ri.citk.policytool.common.excel;

import java.util.List;

import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;

/**
 * ファイルから ExcelPolicy を読み込むインターフェース.
 *
 */
public interface ExcelPolicyReader {
	/**
	 * 指定されたファイル名のEXCEL形式のファイルからポリシー定義を読み込む.
	 * 
	 * @param fileName ファイル名.
	 * @return ポリシー リスト.
	 */
	List<Policy> read(String fileName);
}