package jp.co.ogis_ri.citk.policytool.common.excel;

import java.util.List;

import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;

/**
 * ファイルにExcelPolicyを書き込むインターフェース.
 *
 */
public interface ExcelPolicyWriter {
	/**
	 * ポリシー定義を指定されたファイル名のEXCEL形式のファイルで出力する.
	 * 
	 * @param fileName ファイル名.
	 * @param policies 出力対象のポリシーリスト.
	 */
	void write(String fileName, List<Policy> policies);
}
