package jp.co.ogis_ri.citk.policytool.common.excel.impl;

import java.util.ArrayList;
import java.util.List;

import jp.co.ogis_ri.citk.policytool.common.excel.impl.model.ExcelPolicy;
import jp.co.ogis_ri.citk.policytool.common.exception.SystemException;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Permit;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Resource;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Subject;

/**
 * ExcelPolicyを作成するクラス.
 *
 */
class ExcelPolicyFactory {
	/**
	 * データのリストからExcelPolicyを作成する.
	 * @param values データのリスト.
	 * @return 作成されたExcelPolicy.
	 */
	public static ExcelPolicy create(List<?> values) {
		if(values.size() < ExcelPolicy.ITEM_SIZE) {
			throw new SystemException("size error: " + String.valueOf(values.size()));
		}
		ExcelPolicy excelPolicy = new ExcelPolicy();
		excelPolicy.setRealmName((String )values.get(0));
		excelPolicy.setPolicyName((String )values.get(1));
		excelPolicy.setResourceUrl((String )values.get(2));
		excelPolicy.setGetPermitValue((String )values.get(3));
		excelPolicy.setPostPermitValue((String )values.get(4));
		excelPolicy.setSubject((String )values.get(5));
		
		return excelPolicy;
	}

	/**
	 * PolicyからExcelPolicyを作成する.
	 * @param policy Policy.
	 * @return 作成されたExcelPolicy.
	 */
	public static List<ExcelPolicy> create(Policy policy) {
		List<ExcelPolicy> list = new ArrayList<ExcelPolicy>();
		for(Resource resource : policy.getResources()) {
			ExcelPolicy excelPolicy = new ExcelPolicy();
			excelPolicy.setRealmName(policy.getRealmName());
			excelPolicy.setPolicyName(policy.getPolicyName());
			excelPolicy.setResourceUrl(resource.getResourceUrl());
			excelPolicy.setGetPermitValue(getPermitValue(resource.getGetPermit()));
			excelPolicy.setPostPermitValue(getPermitValue(resource.getPostPermit()));
			list.add(excelPolicy);
		}
		for(Subject subject : policy.getSubjects()) {
			ExcelPolicy excelPolicy = new ExcelPolicy();
			excelPolicy.setRealmName(policy.getRealmName());
			excelPolicy.setPolicyName(policy.getPolicyName());
			excelPolicy.setSubject(subject.getSubjectCode());
			list.add(excelPolicy);
		}
		return list;
	}
	
	/**
	 * Permitに対応する, ExcelPolicyに設定する文字列を取得する.
	 * @param permit Permit.
	 * @return ExcelPolicyに設定する文字列.
	 */
	private static String getPermitValue(Permit permit) {
		if (permit == Permit.INDETERMINATE) {
			return "INDETERMINATE";
		} else {
			return permit.getInternalValue().toUpperCase();
		}
	}
}
