package jp.co.ogis_ri.citk.policytool.common.excel.impl;

import java.io.IOException;
import java.util.List;

import jp.co.ogis_ri.citk.policytool.common.CommonConstants;
import jp.co.ogis_ri.citk.policytool.common.excel.ExcelPolicyReader;
import jp.co.ogis_ri.citk.policytool.common.excel.impl.model.ExcelPolicy;
import jp.co.ogis_ri.citk.policytool.common.exception.ExcelPolicyReadException;
import jp.co.ogis_ri.citk.policytool.common.logging.LogWrapperFactory;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;

import org.apache.commons.logging.Log;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.stereotype.Component;

/**
 * ExcelPolicyをファイルから読み込むクラス.
 *
 */
@Component
public class ExcelPolicyReaderImpl implements ExcelPolicyReader {
	/**
	 * ロガー.
	 */
	private Log logger = LogWrapperFactory.getLog(ExcelPolicyReaderImpl.class);

	/**
	 * コンストラクタ.
	 */
	public ExcelPolicyReaderImpl() {
		super();
	}

	@Override
	public List<Policy> read(String fileName) throws ExcelPolicyReadException {

		PolicyBuilder builder = new PolicyBuilder();
		Workbook workbook = null;
		try {
			workbook = WorkbookWrapper.createHSSFWorkbook(fileName);
		} catch (IOException e) {

			logger.info(e.getMessage());
			throw new ExcelPolicyReadException(fileName, "I-0302", (Object[])null);
		}
		// ワークブックラッパを生成
		WorkbookWrapper workbookWrapper = new WorkbookWrapper(workbook);
		workbookWrapper.selectSheet(CommonConstants.TMPL_SHEET_INDEX, CommonConstants.TMPL_SHEET_ROW_OFFSET, CommonConstants.TMPL_SHEET_COLUMN_OFFSET);
		//　エクスポート用モデルをポリシーに変換
		while(workbookWrapper.existRow()) {
			List<?> values = workbookWrapper.readRow(ExcelPolicy.ITEM_SIZE);
			ExcelPolicy excelPolicy = ExcelPolicyFactory.create(values);
			builder.add(excelPolicy);
		}
		return builder.build();
	}
}
