package jp.co.ogis_ri.citk.policytool.common.exception;

import jp.co.ogis_ri.citk.policytool.common.resource.MessageInfo;

/**
 * アプリケーションの設定が原因の例外.
 *
 */
public class ApplicationSettingException extends ApplicationException {

	/**
	 * シリアルバージョンID.
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * コンストラクタ.
	 * @param messageInfo MessageInfo.
	 * @param cause この例外の原因となった例外.
	 */
	public ApplicationSettingException(MessageInfo messageInfo, Throwable cause) {
		super(messageInfo, cause);
	}

	/**
	 * コンストラクタ.
	 * @param messageInfo MessageInfo.
	 */
	public ApplicationSettingException(MessageInfo messageInfo) {
		super(messageInfo);
	}

	/**
	 * コンストラクタ.
	 * @param code メッセージコード.
	 * @param args メッセージ生成に使用する追加情報.
	 */
	public ApplicationSettingException(String code, Object... args) {
		super(code, args);
	}

	/**
	 * コンストラクタ.
	 * @param cause この例外の原因となった例外.
	 * @param code メッセージコード.
	 * @param args メッセージ生成に使用する追加情報.
	 */
	public ApplicationSettingException(Throwable cause, String code,
			Object... args) {
		super(cause, code, args);
	}
}
