/**
 * 
 */
package jp.co.ogis_ri.citk.policytool.common.exception;

import jp.co.ogis_ri.citk.policytool.common.resource.MessageInfo;

/**
 * ポリシーのインポート時の例外.
 *
 */
public class ExcelPolicyImportException extends ApplicationException {

	/**
	 * シリアルバージョンID.
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * コンストラクタ.
	 * @param messageInfo MessageInfo.
	 */
	public ExcelPolicyImportException(MessageInfo messageInfo) {
		super(messageInfo);
	}

	/**
	 * コンストラクタ.
	 * @param messageInfo MessageInfo.
	 * @param cause この例外の原因となった例外.
	 */
	public ExcelPolicyImportException(MessageInfo messageInfo, Throwable cause) {
		super(messageInfo, cause);
	}

	/**
	 * コンストラクタ.
	 * @param code メッセージコード.
	 * @param args メッセージ生成に使用する追加情報.
	 */
	public ExcelPolicyImportException(String code, Object... args) {
		super(code, args);
	}

	/**
	 * コンストラクタ.
	 * @param cause この例外の原因となった例外.
	 * @param code メッセージコード.
	 * @param args メッセージ生成に使用する追加情報.
	 */
	public ExcelPolicyImportException(Throwable cause, String code,
			Object... args) {
		super(cause, code, args);
	}
}
