package jp.co.ogis_ri.citk.policytool.common.exception;

import jp.co.ogis_ri.citk.policytool.common.resource.MessageInfo;

/**
 * ポリシーを書き込む際の例外.
 *
 */
public class ExcelPolicyWriteException extends ApplicationException {
	/**
	 * シリアルバージョンID.
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * ポリシーの書き込み先のファイル名.
	 */
	private String fileName;
	
	/**
	 * ポリシーの書き込み先のファイル名を取得する.
	 * @return ポリシーの書き込み先のファイル名.
	 */
	public String getFileName() {
		return fileName;
	}

	/**
	 * コンストラクタ.
	 * @param messageInfo MessageInfo.
	 * @param cause この例外の原因となった例外.
	 */
	public ExcelPolicyWriteException(MessageInfo messageInfo, Throwable cause) {
		super(messageInfo, cause);
	}

	/**
	 * コンストラクタ.
	 * @param messageInfo MessageInfo.
	 */
	public ExcelPolicyWriteException(MessageInfo messageInfo) {
		super(messageInfo);
	}

	/**
	 * コンストラクタ.
	 * @param fileName ポリシーの書き込み先のファイル名.
	 * @param code メッセージコード.
	 * @param args メッセージ生成に使用する追加情報.
	 */
	public ExcelPolicyWriteException(String fileName, String code, Object... args) {
		super(code, args);
		this.fileName = fileName;
	}

	/**
	 * コンストラクタ.
	 * @param fileName ポリシーの書き込み先のファイル名.
	 * @param cause この例外の原因となった例外.
	 * @param code メッセージコード.
	 * @param args メッセージ生成に使用する追加情報.
	 */
	public ExcelPolicyWriteException(String fileName, Throwable cause, String code,
			Object... args) {
		super(cause, code, args);
		this.fileName = fileName;
	}
}
