package jp.co.ogis_ri.citk.policytool.common.exception;

/**
 * このアプリケーションで処理する例外のうち, アプリケーションが強制終了するように振舞う例外.
 *
 */
public class SystemException extends RuntimeException {

    /**
	 * シリアルバージョンID.
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * コンストラクタ.
	 */
	public SystemException() {
    }

    /**
     * コンストラクタ.
     * @param message メッセージ文字列.
     */
	public SystemException(String message) {
        super(message);
    }

    /**
     * コンストラクタ.
     * @param cause この例外の原因となった例外.
     */
	public SystemException(Throwable cause) {
        super(cause);
    }

    /**
     * コンストラクタ.
     * @param message メッセージ文字列.
     * @param cause この例外の原因となった例外.
     */
	public SystemException(String message, Throwable cause) {
        super(message, cause);
    }
}
