package jp.co.ogis_ri.citk.policytool.common.http;

import java.io.IOException;

import jp.co.ogis_ri.citk.policytool.common.util.StreamUtil;

import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

/**
 * HttpResponseのラッパークラス.
 *
 */
public class HttpResponseWrapper {
    /** HttpResponse の実体 */
    private HttpResponse httpResponse = null;
    /** コンテンツ */
    private byte[] content = null;
    
    /**
     * コンストラクタ.
     * @param httpResponse HttpResponse.
     */
    protected HttpResponseWrapper(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
        try {
            this.content = StreamUtil.toByteArray(httpResponse.getEntity().getContent());
            EntityUtils.consume(httpResponse.getEntity());
        } catch (IOException e) {
            // NOP
        }
    }

    /**
     * コンテンツをバイト配列で取得する.
     * @return コンテンツのバイト配列.
     */
    public byte[] getContent() {
        return content;
    }

    /**
     * HttpResponseオブジェクトを取得する.
     * @return HttpResponseオブジェクト.
     */
    public HttpResponse getHttpResponse() {
        return httpResponse;
    }
    
    /**
     * プロトコルバージョンを取得する.
     * @return プロトコルバージョン文字列.
     */
    public String getProtocolVersion() {
        return httpResponse.getProtocolVersion().toString();
    }

    /**
     * HTTPステータスコードを取得する.
     * @return HTTPステータスコード.
     */
    public int getHttpStatusCode() {
        return httpResponse.getStatusLine().getStatusCode();
    }

    /**
     * HTTPステータスコードの詳細文字列を取得する.
     * @return HTTPステータスコードの詳細文字列.
     */
    public String getReasonPhrase() {
        return httpResponse.getStatusLine().getReasonPhrase();
    }    
    
    /**
     * 指定された名前に対応するHTTPヘッダを取得する.
     * @param name ヘッダの名前.
     * @return 指定された名前に対応するHTTPヘッダ.
     */
    public Header[] getHeaders(String name) {
        return httpResponse.getHeaders(name);
    }
}
