package jp.co.ogis_ri.citk.policytool.common.repository;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import jp.co.ogis_ri.citk.policytool.common.model.AbstractModel;


/**
 * JPAによりエンティティに対する汎用的な処理を行うクラス.
 *
 * @param <E> エンティティ型.
 * @param <K> 主キー型.
 */
public abstract class JpaGenericRepository<E extends AbstractModel<K>, K extends Serializable> implements GenericRepository<E, K> {
	/**
	 * EntityManager.
	 */
	@PersistenceContext
	protected  EntityManager em;
	
	/**
	 * エンティティのクラス.
	 */
	private Class<E> entityClass;
	
	/**
	 * コンストラクタ.
	 */
	@SuppressWarnings("unchecked")
	public JpaGenericRepository() {
		entityClass = 
			(Class<E>)((ParameterizedType)getClass().getGenericSuperclass()).getActualTypeArguments()[0];
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<E> findAll() {
		return em
			.createQuery("SELECT e FROM " + entityClass.getSimpleName() + " e")
			.getResultList();
	}
	
	@Override
	public E findById(K id) {
		return em.find(entityClass, id);
	}

	@Override
	public void persist(E entity) {
		em.persist(entity);
	}

	@Override
	public E merge(E entity) {
		return em.merge(entity);
	}

	@Override
	public void remove(E entity) {
		em.remove(em.merge(entity)); 
	}

	@Override
	public void removeAll() {
		List<E> realms = findAll();
		for(E realm : realms) {
			em.remove(realm); 
		}
	}
	
	@Override
	public void reflesh(E entity) {
		em.refresh(entity);
	}
}
