package jp.co.ogis_ri.citk.policytool.common.util;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;

import jp.co.ogis_ri.citk.policytool.common.exception.ApplicationSettingException;
import jp.co.ogis_ri.citk.policytool.common.exception.SystemException;

import org.apache.http.conn.HttpHostConnectException;

/**
 * Exception関連の処理のユーティリティクラス.
 *
 */
public class ExceptionUtil {
    /**
     * コンストラクタ.
     */
	private ExceptionUtil() {
	}

	/**
	 * すべての例外を適切な非チェック例外に変換する.
	 * 
	 * @param t 変換対象の例外.
	 * @return 変換後の非チェック例外.
	 */
	public static RuntimeException convertRuntimeException(Throwable t)  {
		// 特定の例外(発生原因がアプリケーション設定など)は、アプリケーション例外扱いとする.
		if(t instanceof HttpHostConnectException) {
			return new ApplicationSettingException(t, "I-0001", ((HttpHostConnectException) t).getHost());
		}
		if(t instanceof UnsupportedEncodingException) {
			return new ApplicationSettingException(t, "I-0003", t.getMessage());
		}

		if(t instanceof Error) {
			throw Error.class.cast(t);
		}
		if(t instanceof RuntimeException) {
			return RuntimeException.class.cast(t);
		}
		if(t instanceof InvocationTargetException) {
			return convertRuntimeException(t.getCause());
		}
		return new SystemException(t);
	}
}
