package jp.co.ogis_ri.citk.policytool.common.validation.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.validation.Constraint;
import javax.validation.Payload;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

/**
 * グループコード単項目チェックの検証アノテーション.
 *
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Constraint(validatedBy = {  })
@NotNull(message="{jp.co.ogis_ri.citk.policytool.common.validation.annotation.GroupCode.NotNull.message.default}")
@Pattern(regexp="[\\w-]+=[\\w-]+(,[\\w-]+=[\\w-]+)*", message="{jp.co.ogis_ri.citk.policytool.common.validation.annotation.GroupCode.Pattern.message.default}")
public @interface GroupCode {
	/** メッセージ. */
	String message() default "{jp.co.ogis_ri.citk.policytool.common.validation.annotation.GroupCode.message.default}";
	
	/** グループ. */ 
	Class<?>[] groups() default {};
	
	/** 荷重. */
	Class<? extends Payload>[] payload() default {};
	
	/**
	 * ルールの内部リスト.
	 */
    @Target({ElementType.FIELD})
    @Retention(RetentionPolicy.RUNTIME)
    @Documented
    @interface List {
    	/** ルールの配列. */
    	GroupCode[] value();
    }
}
