package jp.co.ogis_ri.citk.policytool.common.validation.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.validation.Constraint;
import javax.validation.Payload;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

/**
 * グループ名の単項目チェックの検証アノテーション.
 *
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Constraint(validatedBy = {  })
@NotNull(message="{jp.co.ogis_ri.citk.policytool.common.validation.annotation.GroupName.NotNull.message.default}")
@Size(min=1, max=64, message="{jp.co.ogis_ri.citk.policytool.common.validation.annotation.GroupName.Size.message.default}")
@Pattern(regexp="[\\w-]+", message="{jp.co.ogis_ri.citk.policytool.common.validation.annotation.GroupName.Pattern.message.default}")
public @interface GroupName {
	/** メッセージ. */
	String message() default "{jp.co.ogis_ri.citk.policytool.common.validation.annotation.GroupName.message.default}";
	
	/** グループ. */
	Class<?>[] groups() default {};
	
	/** 荷重. */
	Class<? extends Payload>[] payload() default {};
	
	/**
	 * ルールの内部リスト.
	 */
    @Target({ElementType.FIELD})
    @Retention(RetentionPolicy.RUNTIME)
    @Documented
    @interface List {
    	/** ルールの配列. */
    	GroupName[] value();
    }
}
