package jp.co.ogis_ri.citk.policytool.domain.policy;

import java.util.List;

import jp.co.ogis_ri.citk.policytool.common.repository.GenericRepository;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;

/**
 * ポリシーのエンティティに対する処理を行うインタフェース.
 *
 */
public interface PolicyRepository extends GenericRepository<Policy, Long> {

	/**
	 * 指定されたレルム名のポリシーの同期処理.
	 * @param realmName レルム名.
	 */
	public void sync(String realmName);
	
	/**
	 * 指定されたレルム名のポリシーを取得する.
	 * @param realmName レルム名.
	 * @return 指定されたレルム名のポリシーのリスト.
	 */
	public List<Policy> findPoliciesByRealmName(String realmName);

	/**
	 * 指定されたレルム名, サブジェクト名, URLを持つポリシーを取得する.
	 * @param realmName レルム名.
	 * @param subjectName サブジェクト名.
	 * @param url URL.
	 * @return 指定されたレルム名, サブジェクト名, URL.
	 */
	public List<Policy> findPolicies(String realmName, String subjectName, String url);
	
	/**
	 * 指定されたポリシーをインポートする.
	 * @param policies ポリシーのリスト.
	 */
	public void importPolicies(List<Policy> policies);
}
