/**
 *
 */
package jp.co.ogis_ri.citk.policytool.domain.policy.model;

/**
 * リソースのアクセス権を定義する為のenumeration。
 */
public enum Permit {
    /** アクセス権未定義 */
    INDETERMINATE(""),
    /** アクセス拒否 */
    DENY("deny"),
    /** アクセス許可 */
    ALLOW("allow");
    
    /** 内部値 */
    private String internalValue;
    
    /**
     * コンストラクタ.
     * 
     * @param internalValue 内部値
     */
    private Permit(String internalValue) {
    	this.internalValue = internalValue;
    }

    /**
     * 内部値を取得する.
     * 
     * @return　内部値
     */
    public String getInternalValue() {
		return this.internalValue;
	}
    
    /**
     * 内部値から列挙体へ変換する.
     * 
     * @param internalValue 内部値
     * @return 列挙体
     */
    public static Permit internalValueOf(String internalValue) {
    	for(Permit permit : Permit.values()) {
    		if(permit.getInternalValue().equals(internalValue)) {
    			return permit;
    		}
    	}
    	throw new IllegalArgumentException();
    }
}
