package jp.co.ogis_ri.citk.policytool.domain.policy.validation;

import java.util.ArrayList;
import java.util.List;

import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation.RuleResourceSize;
import jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation.RuleResourceValidPermit;
import jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation.RuleSubjectDependOnRealm;
import jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation.RuleSubjectSize;
import jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation.RuleUniquePolicyName;
import jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation.RuleUniqueResourceUrl;
import jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation.RuleUrlDependOnRealm;
import jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation.RuleValidRealmName;

/**
 * ポリシーの相関チェック用のモデル.
 *
 */
@RuleValidRealmName(groups={ PolicyValidModel.Create.class, PolicyValidModel.Import.class }, message="{jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation.RuleValidRealmName.message.default}")
@RuleUniquePolicyName(groups={ PolicyValidModel.Create.class }, message="{jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation.RuleUniquePolicyName.message.default}")
@RuleResourceSize(groups={ PolicyValidModel.Create.class, PolicyValidModel.Update.class, PolicyValidModel.Import.class }, message="{jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation.RuleResourceSize.message.default}")
@RuleUrlDependOnRealm(groups={ PolicyValidModel.Create.class, PolicyValidModel.Update.class, PolicyValidModel.Import.class }, message="{jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation.RuleUrlDependOnRealm.message.default}")
@RuleUniqueResourceUrl(groups={ PolicyValidModel.Create.class, PolicyValidModel.Update.class, PolicyValidModel.Import.class }, message="{jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation.RuleUniqueResourceUrl.message.default}")
@RuleSubjectSize(groups={ PolicyValidModel.Create.class, PolicyValidModel.Update.class, PolicyValidModel.Import.class }, message="{jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation.RuleSubjectSize.message.default}")
@RuleSubjectDependOnRealm(groups={ PolicyValidModel.Create.class, PolicyValidModel.Update.class, PolicyValidModel.Import.class }, message="{jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation.RuleSubjectDependOnRealm.message.default}")
@RuleResourceValidPermit(groups={ PolicyValidModel.Create.class, PolicyValidModel.Update.class, PolicyValidModel.Import.class }, message="{jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation.RuleResourceValidPermit.message.default}")
public class PolicyValidModel {
	
	/** target.realmNameに対応するレルムの有無 */
	private boolean isExistRealm;
	
	/** target.realmNameに対応するレルムが持っている参照ポリシー */
	private List<String> refpolicies = new ArrayList<String>();
	
	/**
	 * target.realmNameに対応するレルムが持っているグループ名<br>
	 * グループ名は、groupName + "(" + groupCode + ")"
	 */
	private List<String> groups = new ArrayList<String>();
	
	/** 全ポリシー名のリスト */
	private List<String> policyNames = new ArrayList<String>();

	/**
	 * チェック対象のポリシー.
	 */
	private Policy target;
	
	/**
	 * ポリシー作成時のチェックの際に指定するインターフェース.
	 */
	public interface Create {}
	
	/**
	 * ポリシー更新時のチェックの際に指定するインターフェース.
	 */
	public interface Update {}

	/**
	 * ポリシーインポート時のチェックの際に指定するインターフェース.
	 */
	public interface Import {}
	
	/**
	 * コンストラクタ.
	 */
	public PolicyValidModel() {
	}

	/**
	 * target.realmNameに対応するレルムの有無を取得する.
	 * @return target.realmNameに対応するレルムの有無.
	 */
	public boolean getIsExistRealm() {
		return this.isExistRealm;
	}
	
	/**
	 * target.realmNameに対応するレルムの有無を設定する.
	 * @param isExistRealm target.realmNameに対応するレルムの有無.
	 */
	public void setIsExistRealm(boolean isExistRealm) {
		this.isExistRealm = isExistRealm;
	}
	
	/**
	 * target.realmNameに対応するレルムが持っている参照ポリシーのリストを取得する.
	 * @return target.realmNameに対応するレルムが持っている参照ポリシーのリスト.
	 */
	public List<String> getRefpolicies() {
		return this.refpolicies;
	}
	
	/**
	 * target.realmNameに対応するレルムが持っているグループ名のリストを取得する.
	 * @return target.realmNameに対応するレルムが持っているグループ名のリスト.
	 */
	public List<String> getGroups() {
		return this.groups;
	}
	
	/**
	 * 全ポリシー名のリストを取得する.
	 * @return 全ポリシー名のリスト.
	 */
	public List<String> getPolicyNames() {
		return this.policyNames;
	}
	
	/**
	 * チェック対象のポリシーを取得する.
	 * @return チェック対象のポリシー.
	 */
	public Policy getTarget() {
		return this.target;
	}

	/**
	 * チェック対象のポリシーを設定する.
	 * @param target チェック対象のポリシー.
	 */
	public void setTarget(Policy target) {
		this.target = target;
	}
}
