package jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashSet;
import java.util.Set;

import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import javax.validation.ConstraintValidatorContext.ConstraintViolationBuilder;

import jp.co.ogis_ri.citk.policytool.domain.policy.model.Resource;
import jp.co.ogis_ri.citk.policytool.domain.policy.validation.PolicyValidModel;

/**
 * Policy内のリソースのURLが一意であることをチェックする相関項目チェックの, 検証アノテーション.
 * 
 */
@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Constraint(validatedBy = { RuleUniqueResourceUrl.Validator.class })
public @interface RuleUniqueResourceUrl {
	/** メッセージ. */
	String message() default "{jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation.RuleUniqueResourceUrl.message.default}";
	
	/** グループ. */
	Class<?>[] groups() default {};
	
	/** 荷重. */
	Class<? extends Payload>[] payload() default {};
	
	/**
	 * ルールの内部リスト.
	 */
    @Target({ElementType.TYPE})
    @Retention(RetentionPolicy.RUNTIME)
    @Documented
    @interface List {
    	/** ルールの配列. */
    	RuleUrlDependOnRealm[] value();
    }
    
    /**
     * バリデータ.
     */
	class Validator implements ConstraintValidator<RuleUniqueResourceUrl, PolicyValidModel> {
		@Override
		public void initialize(RuleUniqueResourceUrl arg0) {
		}

		@Override
		public boolean isValid(PolicyValidModel arg0, ConstraintValidatorContext arg1) {
			// Policy 内のリソースの URL は、一意であること
			// (Set にすべて格納してみて, 重複で格納できないものがないか確認)
			Set<String> resourceUrlSet = new HashSet<String>();
			for (int i = 0; i < arg0.getTarget().getResources().size(); i++) {
				Resource resource = arg0.getTarget().getResources().get(i);
				boolean addResult = resourceUrlSet.add(resource.getResourceUrl());
				if (!addResult) {
					arg1.disableDefaultConstraintViolation();
					String messageTemplate = arg1.getDefaultConstraintMessageTemplate();
					ConstraintViolationBuilder builder = arg1.buildConstraintViolationWithTemplate(messageTemplate + "、値=" + resource.getResourceUrl());
					builder
						.addNode("policy")
						.addNode("resources")
						.addNode("resourcesUrl")
						.inIterable().atIndex(i)
						.addConstraintViolation();
					
					return false;
				}
			}
			
			return true;
		}
	}
}
