package jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintValidatorContext.ConstraintViolationBuilder;
import javax.validation.Payload;

import jp.co.ogis_ri.citk.policytool.domain.policy.model.Resource;
import jp.co.ogis_ri.citk.policytool.domain.policy.validation.PolicyValidModel;

/**
 * リソースのURLがレルムドメインの参照ポリシーがベースであることをチェックする相関項目チェックの, 検証アノテーション.
 *
 */
@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Constraint(validatedBy = { RuleUrlDependOnRealm.Validator.class })
public @interface RuleUrlDependOnRealm {
	/** メッセージ. */
	String message() default "{jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation.RuleUrlDependOnRealm.message.default}";
	
	/** グループ. */
	Class<?>[] groups() default {};
	
	/** 荷重. */
	Class<? extends Payload>[] payload() default {};

	/**
	 * ルールの内部リスト.
	 */
    @Target({ElementType.TYPE})
    @Retention(RetentionPolicy.RUNTIME)
    @Documented
    @interface List {
    	/** ルールの配列. */
    	RuleUrlDependOnRealm[] value();
    }
    
    /**
     * バリデータ.
     */
	class Validator implements ConstraintValidator<RuleUrlDependOnRealm, PolicyValidModel> {
		@Override
		public void initialize(RuleUrlDependOnRealm arg0) {
		}

		@Override
		public boolean isValid(PolicyValidModel arg0, ConstraintValidatorContext arg1) {
			int i = 0;
			// そのリソースの URL はレルムドメインの参照ポリシーがベースであること
			for (Resource resource : arg0.getTarget().getResources()) {
				boolean contains = false;
				for (String refpolicy : arg0.getRefpolicies()) {
			        Matcher m = Pattern.compile(refpolicy).matcher(resource.getResourceUrl());
					if (m.find()) {
						contains = true;
					}
				}
				
				if (!contains) {
					arg1.disableDefaultConstraintViolation();
					String messageTemplate = arg1.getDefaultConstraintMessageTemplate();
					ConstraintViolationBuilder builder = arg1.buildConstraintViolationWithTemplate(messageTemplate + "、値=" + resource.getResourceUrl());
					builder
						.addNode("policy")
						.addNode("resources")
						.addNode("resourceUrl")
						.inIterable().atIndex(i)
						.addConstraintViolation();
					
					return false;
				}
				i++;
			}

			return true;
		}
	}
}
