package jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import javax.validation.ConstraintValidatorContext.ConstraintViolationBuilder;

import jp.co.ogis_ri.citk.policytool.domain.policy.validation.PolicyValidModel;

/**
 * ポリシーのレルム名がレルムドメインで存在することをチェックする相関項目チェックの, 検証アノテーション.
 *
 */
@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Constraint(validatedBy = { RuleValidRealmName.Validator.class })
public @interface RuleValidRealmName {
	/** メッセージ. */
	String message() default "{jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation.RuleValidRealmName.message.default}";
	
	/** グループ. */
	Class<?>[] groups() default {};
	
	/** 荷重. */
	Class<? extends Payload>[] payload() default {};
	
	/**
	 * ルールの内部リスト.
	 */
    @Target({ElementType.TYPE})
    @Retention(RetentionPolicy.RUNTIME)
    @Documented
    @interface List {
    	/** ルールの配列. */
    	RuleValidRealmName[] value();
    }
    
    /**
     * バリデータ.
     */
	public class Validator implements ConstraintValidator<RuleValidRealmName, PolicyValidModel> {
		@Override
		public void initialize(RuleValidRealmName arg0) {
		}

		@Override
		public boolean isValid(PolicyValidModel arg0, ConstraintValidatorContext arg1) {
			// Policy の realmName は、レルムドメインで存在すること。
			boolean result = arg0.getIsExistRealm();
			if (result) {
				return true;
			} else {
				
				arg1.disableDefaultConstraintViolation();
				String messageTemplate = arg1.getDefaultConstraintMessageTemplate();
				ConstraintViolationBuilder builder = arg1.buildConstraintViolationWithTemplate(messageTemplate + "、値=" + arg0.getTarget().getRealmName());
				builder
					.addNode("policy")
					.addNode("realmName")
					.addConstraintViolation();
				
				return false;
			}
		}
	}
}
