package jp.co.ogis_ri.citk.policytool.domain.realm;

import java.util.List;

import jp.co.ogis_ri.citk.policytool.common.repository.GenericRepository;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Group;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Realm;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Referral;

/**
 * レルムのエンティティに対する処理を行うインタフェース.
 *
 */
public interface RealmRepository extends GenericRepository<Realm, Long> {
	/**
	 * レルムの同期処理を行う.
	 */
	void sync();

	/**
	 * 指定されたレルムのグループ名を検索する.
	 * @param realm レルム.
	 * @return グループ名のリスト.
	 */
	List<String> findGroupNames(Realm realm);
	
	/**
	 * 指定されたレルムのリファーラルを検索する.
	 * @param realm レルム.
	 * @return リファーラルのリスト.
	 */
	List<Referral> findReferrals(Realm realm);

	/**
	 * 指定された名前のレルムを検索する.
	 * @param realmName レルム名.
	 * @return 指定された名前のレルム.
	 */
    Realm findRealmByName(String realmName);

    /**
     * 指定されたレルムのグループを検索する.
     * @param realm レルム.
     * @return グループ.
     */
    List<Group> findGroupByRealm(Realm realm);

    /**
     * 指定されたレルム, グループ名のグループを検索する.
     * @param realm レルム.
     * @param groupName グループ名.;
     * @return グループ.
     */
    Group findGroupByName(Realm realm, String groupName);
}
