package jp.co.ogis_ri.citk.policytool.domain.realm.impl;

import java.util.List;
import jp.co.ogis_ri.citk.policytool.common.api.OpenAMAccess;
import jp.co.ogis_ri.citk.policytool.common.repository.JpaGenericRepository;
import jp.co.ogis_ri.citk.policytool.domain.realm.RealmRepository;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Group;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Realm;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Referral;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

/**
 * JPAによりレルムのエンティティに対する処理を行うクラス.
 *
 */
@Repository
public class JpaRealmRepositoryImpl extends JpaGenericRepository<Realm, Long>
        implements RealmRepository {
	/**
	 * OpenAMアクセスオブジェクト.
	 */
	@Autowired(required=false)
	private OpenAMAccess amAccess = null;

	/**
	 * レルムリスト同期処理
	 * 
	 * OpenAMサーバからレルムリストを取得、
	 * システム内データベースとサーバのレルムリストを同期する。
	 */
	@Override
    public void sync() {
		List<Realm> realms = amAccess.getRealms("/", "*");
		
		removeAll();
		em.flush();
		for(Realm realm : realms) {
			persist(realm);
		}
		em.flush();
    }

	/**
	 * グループ名リスト取得
	 * 
	 * データベース内に存在するグループ名のリストを、重複するものは除いて参照する。
	 * 
	 * @return グループ名文字列のリスト
	 */
	@Override
	@SuppressWarnings("unchecked")
	public List<String> findGroupNames(Realm realm) {
        // return em.createQuery("SELECT e FROM Group e where (e.groupName) in (SELECT DISTINCT e.groupName FROM Group e) order by e.groupName").getResultList();
	    String queryString = "SELECT DISTINCT e.groupName FROM Group e";
	    if (realm != null) {
	        queryString += " where e.realm.realmName = '" + realm.getRealmName() + "'";
	    }
	    queryString += " order by e.groupName";
		return em.createQuery(queryString).getResultList();
	}

	/**
	 * 参照ポリシーリスト参照
	 * 
	 * データベース内の参照ポリシーを参照する。
	 * 
	 * @return 参照ポリシーのリスト
	 */
    @Override
	@SuppressWarnings("unchecked")
	public List<Referral> findReferrals(Realm realm) {
	    String queryString = "SELECT e FROM Referral e";
	    if (realm != null) {
	        queryString += " where e.realm.realmName = '" + realm.getRealmName() + "'";
	    }
	    queryString += " order by e.refpolicy";
		return em.createQuery(queryString).getResultList();
	}
	
    @Override
	@SuppressWarnings("unchecked")
	public List<Realm> findAll() {
	    return em.createQuery("SELECT e FROM Realm e order by e.realmName").getResultList();
	}

    @Override
    public Realm findRealmByName(String realmName) {
        String queryString = "SELECT e FROM Realm e";
        if (realmName != null && realmName.length() > 0) {
            queryString += " where e.realmName = '" + realmName + "'";
        }
        return (Realm) em.createQuery(queryString).getResultList().get(0);
    }

    @Override
    @SuppressWarnings("unchecked")
    public List<Group> findGroupByRealm(Realm realm) {
        String queryString = "SELECT e FROM Group e";
        if (realm != null) {
            queryString += " where e.realm.realmName = '" + realm.getRealmName() + "'";
        }
        queryString += " order by e.groupName";

        return em.createQuery(queryString).getResultList();
    }

    @Override
    @SuppressWarnings("unchecked")
    public Group findGroupByName(Realm realm, String groupName) {
         return ((List<Group>) em.createQuery("SELECT e FROM Group e where e.realm.realmName = :RealmName AND e.groupName = :GroupName")
                .setParameter("RealmName", realm.getRealmName()).setParameter("GroupName", groupName).getResultList()).get(0);
    }
}
