/**
 * 
 */
package jp.co.ogis_ri.citk.policytool.domain.realm.model;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

import jp.co.ogis_ri.citk.policytool.common.model.AbstractModel;
import jp.co.ogis_ri.citk.policytool.common.validation.annotation.GroupCode;
import jp.co.ogis_ri.citk.policytool.common.validation.annotation.GroupName;

/**
 * グループを表すクラス.
 */
@Entity
@Table(name="t_group")
public class Group  extends AbstractModel<Long> {
	/**
	 * シリアルバージョンID.
	 */
    private static final long serialVersionUID = 1L;

    /** JPAで永続化するためのサロゲートキー */
    @Id
    @GeneratedValue
    private Long id;

    /**
     * グループ名
     */
    @GroupName
    private String groupName = null;

    /**
     * グループコード 
     */
    @GroupCode
    private String groupCode = null;
    
    /** 
     * レルム
     */
    @ManyToOne(fetch= FetchType.LAZY)
    @NotNull
    private Realm realm = null;
    
    @Override
    public Long getId() {
        return this.id;
    }

    /**
     * グループ名を取得する.
     * @return グループ名.
     */
    public String getGroupName() {
        return groupName;
    }
    
    /**
     * グループ名を設定する.
     * @param groupName グループ名.
     */
    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    /**
     * グループコードを取得する.
     * @return グループコード.
     */
    public String getGroupCode() {
        return groupCode;
    }

    /**
     * グループコードを設定する.
     * @param groupCode グループコード.
     */
    public void setGroupCode(String groupCode) {
        this.groupCode = groupCode;
    }

    /**
     * このグループを持つレルムを取得する.
     * @return このグループを持つレルム.
     */
    public Realm getRealm() {
        return realm;
    }

    /**
     * このグループを持つレルムを設定する.
     * @param realm このグループを持つレルム.
     */
    public void setRealm(Realm realm) {
        this.realm = realm;
    }

    /**
     * コンストラクタ.
     */
    public Group() {
    }

    /**
     * コンストラクタ.
     * @param groupName グループ名.
     * @param groupCode グループコード.
     */
    public Group(String groupName, String groupCode) {
        this.groupName = groupName;
        this.groupCode = groupCode;
    }
}
