package jp.co.ogis_ri.citk.policytool.service.common.validation;

import java.util.List;

import jp.co.ogis_ri.citk.policytool.common.util.ApplicationContextUtil;
import jp.co.ogis_ri.citk.policytool.domain.policy.PolicyRepository;
import jp.co.ogis_ri.citk.policytool.domain.policy.impl.JpaPolicyRepositoryImpl;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import jp.co.ogis_ri.citk.policytool.domain.policy.validation.PolicyValidModel;
import jp.co.ogis_ri.citk.policytool.domain.realm.RealmRepository;
import jp.co.ogis_ri.citk.policytool.domain.realm.impl.JpaRealmRepositoryImpl;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Group;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Realm;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Referral;

/**
 * ポリシー相関チェック用のモデル PolicyValidModel を作成するクラス.
 *
 */
public class PolicyValidModelFactory {
	/**
	 * コンストラクタ.
	 */
	public PolicyValidModelFactory() {
	}
	
	/**
	 * 指定された Policy に対応する PolicyValidModel を作成.<br>
	 * 
	 * @param policy
	 *            PolicyValidModel 作成対象の Policy.
	 * @return Policy に対応する PolicyValidModel.
	 */
	public static PolicyValidModel create(Policy policy) {
	    PolicyRepository policyRepository = ApplicationContextUtil.getBean(JpaPolicyRepositoryImpl.class);
	    RealmRepository realmRepository = ApplicationContextUtil.getBean(JpaRealmRepositoryImpl.class);
	    
		PolicyValidModel model = new PolicyValidModel();
		model.setTarget(policy);
		
		// 対応するレルム
		Realm realm = null;
		List<Realm> realmList = realmRepository.findAll();
		for (Realm currentRealm : realmList) {
			if (policy.getRealmName().equals(currentRealm.getRealmName())) {
				realm = currentRealm;
				break;
			}
		}
		
		// 対応するレルムの有無
		boolean isExistRealm;
		if (realm == null) {
			isExistRealm = false;
		} else {
			isExistRealm = true;
		}
		
		model.setIsExistRealm(isExistRealm);
		
		// レルムが持っている参照ポリシー.
		if (realm != null) {
			for (Referral referral : realm.getReferrals()) {
				String refpolicy = referral.getRefpolicy();
				model.getRefpolicies().add(refpolicy);
			}
		}
		
		// レルムが持っているグループ名
		if (realm != null) {
			for (Group group : realm.getGroups()) {
				String fullGroupName = group.getGroupName() + "(" + group.getGroupCode() + ")";
				model.getGroups().add(fullGroupName);
			}
		}
		
		// 全ポリシーのリスト
		List<Policy> policyList = policyRepository.findAll();
		for (Policy currentPolicy : policyList) {
			model.getPolicyNames().add(currentPolicy.getPolicyName());
		}
		
		return model;
	}
}
