/**
 * 
 */
package jp.co.ogis_ri.citk.policytool.service.policylist.impl;

import java.util.List;

// import javax.validation.Validator;

import jp.co.ogis_ri.citk.policytool.domain.policy.PolicyRepository;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import jp.co.ogis_ri.citk.policytool.domain.realm.RealmRepository;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Realm;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Referral;
import jp.co.ogis_ri.citk.policytool.service.policylist.PolicyListService;
import jp.co.ogis_ri.citk.policytool.service.policylist.model.PolicyView;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * ポリシー一覧サービスの実装.
 */
@Service
class PolicyListServiceImpl implements PolicyListService {
	/**
	 * RealmRepository.
	 */
    @Autowired
    private RealmRepository realmRepository = null;

    /**
     * PolicyRepository. 
     */
    @Autowired
    private PolicyRepository policyRepository = null;

    /**
     * 新しい PolicyListService を構築します.
     */
    public PolicyListServiceImpl() {
    }

    public void delete(Policy policy) {
        policyRepository.remove(policy);
    }

    public void refresh() {
    	realmRepository.sync();
    	policyRepository.removeAll();
    	for(Realm realm : realmRepository.findAll()) {
    		policyRepository.sync(realm.getRealmName());
    	}
    }

    public List<Realm> findRealms() {
    	// 派生クラスにレルム名でソートしたfindAllを実装する。
    	return realmRepository.findAll();
    }

    public List<String> findGroupNames(Realm realm) {
    	return realmRepository.findGroupNames(realm);
    }

    public List<Referral> findReferrals(Realm realm) {
    	return realmRepository.findReferrals(realm);
    }

    public List<PolicyView> findPolicies(String realmName, String groupCode,
            String resourceUrl) {
    	return PolicyView.create(policyRepository.findPolicies(realmName, groupCode, resourceUrl));
    }
}
