/**
 * 
 */
package jp.co.ogis_ri.citk.policytool.service.policylist.model;

import java.util.ArrayList;
import java.util.List;

import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Resource;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Subject;

/**
 * ポリシー一覧画面のポリシー表示項目.
 */
public class PolicyView {
	/**
	 * レルム名.
	 */
	private String realmName;
	
	/**
	 * ポリシー名.
	 */
	private String policyName;
	
	/**
	 * リソースURLのリスト.
	 */
	private List<String> resourceUrls;
	
	/**
	 * サブジェクトのリスト.<br>
	 * サブジェクト1行のイメージ : subjectName +"("+subjectCode+")"
	 */
	private List<String> subjects;
	
	/**
	 * ポリシー.
	 */
	private Policy policy;

	/**
	 * コンストラクター.
	 *
	 * @param policy ポリシーモデル
	 */
	private PolicyView(Policy policy) {
		this.realmName = policy.getRealmName();
		this.policyName = policy.getPolicyName();

		this.resourceUrls = new ArrayList<String>();
		for (Resource resource : policy.getResources()) {
			this.resourceUrls.add(resource.getResourceUrl());
		}

		this.subjects = new ArrayList<String>();
		for (Subject subject : policy.getSubjects()) {
			this.subjects.add(subject.getSubjectName() + " (" + subject.getSubjectCode() + ")");
		}

		this.policy = policy;
	}
	
	/**
	 * PolicyViewを作成する.
	 * @param policies ポリシーのリスト.
	 * @return PolicyView.
	 */
	public static List<PolicyView> create(List<Policy> policies) {
		List<PolicyView> list = new ArrayList<PolicyView>();
		for(Policy policy : policies) {
			list.add(new PolicyView(policy));
		}
		return list;
	}
	
	/**
	 * レルム名を取得する.
	 * @return レルム名.
	 */
	public String getRealmName() {
		return realmName;
	}

	/**
	 * ポリシー名を取得する.
	 * @return　ポリシー名.
	 */
	public String getPolicyName() {
		return policyName;
	}

	/**
	 * リソースURLの配列を取得する.
	 * @return リソースURLの配列.
	 */
	public String[] getResourceUrls() {
		int size = resourceUrls.size();
		String ret[] = new String[size];
		for (int i = 0; i < size; i++) {
			ret[i] = resourceUrls.get(i);
		}
		return ret;
	}
	
	/**
	 * サブジェクトの配列を取得する.
	 * @return サブジェクトの配列.
	 */
	public String[] getSubjects() {
		int size = subjects.size();
		String ret[] = new String[size];
		for (int i = 0; i < size; i++) {
			ret[i] = subjects.get(i);
		}
		return ret;
	}

	/**
	 * モデルを取得する.
	 * 
	 * @return ポリシーモデル
	 */
	public Policy getPolicy() {
		return policy;
	}
}
