package jp.co.ogis_ri.citk.policytool.service.policyset;

import java.util.List;

import javax.validation.ConstraintViolation;

import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Group;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Realm;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Referral;

/**
 * ポリシー設定サービスのインターフェース.
 */
public interface PolicySetService {
	/**
	 * レルムを検索する.
	 * @return レルムのリスト.
	 */
	public List<Realm> findRealms();

	/**
	 * 指定された名前のレルムを検索する.
	 * @param realmName レルム名.
	 * @return レルム.
	 */
	Realm findRealmByName(String realmName);

	/**
	 * 指定されたレルムのグループを検索する.
	 * @param realm レルム.
	 * @return グループのリスト.
	 */
	List<Group> findGroupByRealm(Realm realm);

	/**
	 * 指定されたレルムのリファーラルを検索する.
	 * @param realmModel レルム.
	 * @return リファーラルのリスト.
	 */
	List<Referral> findReferrals(Realm realmModel);

	/**
	 * 指定されたポリシーの追加処理を行う.
	 * @param policy ポリシー.
	 * @return 追加処理時のバリデーションの結果.
	 */
	ConstraintViolation<?> addPolicy(Policy policy);

	/**
	 * 指定されたポリシーの変更処理を行う.
	 * @param policy ポリシー.
	 * @return 変更処理時のバリデーションの結果.
	 */
	ConstraintViolation<?> modifyPolicy(Policy policy);
}
