package jp.co.ogis_ri.citk.policytool.view.about;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTextArea;

import org.springframework.context.support.MessageSourceAccessor;

/**
 * バージョン情報画面.
 *
 */
public class AboutView extends JDialog {
    /**
	 * シリアルバージョンID.
	 */
	private static final long serialVersionUID = 1L;

	/** MessageSourceAccessor. */
    private MessageSourceAccessor messages = null;

    /**
     * バージョン情報を表示する JTextArea.
     */
    private JTextArea aboutTextArea;
    
    /**
     * OKボタン.
     */
    private JButton okButton;
    
    /**
     * 画面の初期化を行う.
     */
	public void init() {
		setTitle(messages.getMessage("view.aboutView.title"));
		setSize(300, 200);
		setMinimumSize(new Dimension(300, 200));
		setLocationRelativeTo(null);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[] { 0 };
        gridBagLayout.rowHeights = new int[] { 0, 0 };
        gridBagLayout.columnWeights = new double[] { Double.MIN_VALUE };
        gridBagLayout.rowWeights = new double[] { 0.0, Double.MIN_VALUE };
        getContentPane().setLayout(gridBagLayout);
        
        aboutTextArea = new JTextArea();
        GridBagConstraints gbc_aboutTextField = new GridBagConstraints();
        gbc_aboutTextField.weighty = 1.0;
        gbc_aboutTextField.weightx = 1.0;
        gbc_aboutTextField.insets = new Insets(10, 10, 5, 10);
        gbc_aboutTextField.fill = GridBagConstraints.BOTH;
        gbc_aboutTextField.gridx = 0;
        gbc_aboutTextField.gridy = 0;
        getContentPane().add(aboutTextArea, gbc_aboutTextField);
        aboutTextArea.setText(messages.getMessage("view.aboutView.content"));
        aboutTextArea.setBackground(getBackground());
        aboutTextArea.setEditable(false);
        
        okButton = new JButton(messages.getMessage("view.aboutView.okButton"));
        GridBagConstraints gbc_okButton = new GridBagConstraints();
        gbc_okButton.weighty = 0.0;
        gbc_okButton.weightx = 1.0;
        gbc_okButton.insets = new Insets(0, 10, 10, 10);
        gbc_okButton.fill = GridBagConstraints.VERTICAL;
        gbc_okButton.gridx = 0;
        gbc_okButton.gridy = 1;
        getContentPane().add(okButton, gbc_okButton);
        okButton.setPreferredSize(new Dimension(120, 32));
        okButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                ok();
            }
        });
	}
	
    /**
     * 新しい PolicySetView を構築します.
     * 
     * @param mes MessageSourceAccessor.
     */
    private AboutView(MessageSourceAccessor mes) {
        messages = mes;
        init();
    }
	
    /**
     * OKボタン押下時の処理.
     */
    private void ok() {
    	setVisible(false);
    }
}
