package jp.co.ogis_ri.citk.policytool.view.common;

import javax.swing.ComboBoxModel;

/**
 * ComboBoxModel 関連のユーティリティクラス.
 */
class ComboBoxModelUtil {

    /**
     * 新しい ComboBoxModelUtil を構築します.
     */
    private ComboBoxModelUtil() {
    }
    
    /**
     * 指定された ComboBoxModel で, 指定された値から始まる文字列項目を検索し, 最初に見つかったもののインデックスを返します.
     * 
     * @param aModel コンボボックスモデル.
     * @param startIndex 検索開始インデックス位置. このインデックスから末尾に向かって検索し, 末尾に達すると先頭から継続し,
     *            このインデックスの1個前で終了します.
     * @param searchValue 検索文字列.
     * @return 最初に見つかった文字列項目のインデックス.
     * 
     */
    static int getSelectionForKey(ComboBoxModel aModel, int startIndex,
            String searchValue) {
        if (startIndex == -1) {
            startIndex = 0;
        }

        for (int i = startIndex; i < aModel.getSize(); i++) {
            if (startsWithSearchValue(aModel, i, searchValue)) {
                return i;
            }
        }

        for (int i = 0; i < startIndex; i++) {
            if (startsWithSearchValue(aModel, i, searchValue)) {
                return i;
            }
        }

        return -1;
    }

    /**
     * 指定されたインデックスの項目の文字列が, 指定された文字列で開始しているかを取得します.
     * 
     * @param aModel コンボボックスモデル.
     * @param index 項目のインデックス.
     * @param searchValue 検索文字列.
     * @return 指定された文字列で開始している場合 true, そうでない場合 false.
     * 
     */
    private static boolean startsWithSearchValue(ComboBoxModel aModel,
            int index, String searchValue) {
        Object item = aModel.getElementAt(index);
        if (item.toString().startsWith(searchValue)) {
            return true;
        } else {
            return false;
        }
    }
}
