package jp.co.ogis_ri.citk.policytool.view.common;

import java.awt.Component;
import java.awt.FontMetrics;

import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.util.EventObject;

/**
 * JTable の コンボボックスセルの, TableCellEditor.
 */
public class ComboBoxTableCellEditor extends JComboBox implements
        TableCellEditor {
	/**
	 * シリアルバージョンID.
	 */
    private static final long serialVersionUID = 1L;

    /** コンボボックスのボタン部とその他余白の幅 */
    private static final int BUTTON_AND_BLANK_WIDTH = 30;

    /**
     * イベントリスナのリスト.
     */
    protected EventListenerList listenerList = new EventListenerList();
    
    /**
     * セル変更時のイベント.
     */
    protected ChangeEvent changeEvent = new ChangeEvent(this);

    /**
     * 新しい ComboBoxTableCellEditor を構築します.
     * 
     * @param items コンボボックスの項目の配列.
     */
    public ComboBoxTableCellEditor(Object[] items) {
        super();
        for (Object item : items) {
            addItem(item);
        }
        addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent event) {
                fireEditingStopped();
            }
        });
    }

    public void addCellEditorListener(CellEditorListener listener) {
        listenerList.add(CellEditorListener.class, listener);
    }

    public void removeCellEditorListener(CellEditorListener listener) {
        listenerList.remove(CellEditorListener.class, listener);
    }

    /**
     * 編集を中断します.
     * 
     */
    protected void fireEditingStopped() {
        CellEditorListener listener;
        Object[] listeners = listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i++) {
            if (listeners[i] == CellEditorListener.class) {
                listener = (CellEditorListener) listeners[i + 1];
                listener.editingStopped(changeEvent);
            }
        }
    }

    /**
     * 編集をキャンセルします.
     * 
     */
    protected void fireEditingCanceled() {
        CellEditorListener listener;
        Object[] listeners = listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i++) {
            if (listeners[i] == CellEditorListener.class) {
                listener = (CellEditorListener) listeners[i + 1];
                listener.editingCanceled(changeEvent);
            }
        }
    }

    public void cancelCellEditing() {
        fireEditingCanceled();
    }

    public boolean stopCellEditing() {
        fireEditingStopped();
        return true;
    }

    public boolean isCellEditable(EventObject event) {
        return true;
    }

    public boolean shouldSelectCell(EventObject event) {
        return true;
    }

    public Object getCellEditorValue() {
        return this.getSelectedItem();
    }

    public Component getTableCellEditorComponent(JTable table, Object value,
            boolean isSelected, int row, int column) {

        this.setSelectedItem(value);

        return this;
    }

    /**
     * 自動セル幅設定時のセル幅を取得します. <br>
     * 
     * @return 自動セル幅設定時のセル幅.
     * 
     */
    public int getAutoCellWidth() {
        FontMetrics metrics = this.getFontMetrics(this.getFont());

        int maxWidth = -1;
        for (int i = 0; i < this.getItemCount(); i++) {
            Object item = this.getItemAt(i);
            String string = item.toString();
            int currentWidth = metrics.stringWidth(string);

            maxWidth = Math.max(currentWidth, maxWidth);
        }

        int widthWithButtonAndBlank = maxWidth + BUTTON_AND_BLANK_WIDTH;

        return widthWithButtonAndBlank;
    }

}
